'BASES.BAS Version 1.00. 1st March 1997. Ian Howlett.
'----------------------------------------------------


'This BAS file is used for converting numbers between one base and another.
'Bases 2-36 are handled, using digits 0-9 and then A-Z to give the 36
'"digits" needed.

'The functions do not handle numbers with a point (real numbers) or negative
'values (less than 0).


'There are two functions:

'DecimalToBase converts a decimal to a base.
'BaseToDecimal converts a number stored in another base to decimal (base 10).



'Usage Guide
'------------

'To convert 95 in base 10 (decimal) to base 8 (octal), use
'    DecimalToBase(95,8)


'To convert 137 in base 8 (octal) to base 10 (decimal), use
'    BaseToDecimal("137",8)
'    (Remember the "" signs!)


'To convert a number in a non-decimal base to another non-decimal base,
'for example 42 in base 2 (binary) is 101010, but 2A in base 16 (hex). To
'convert it use:
'    DecimalToBase(BaseToDecimal("101010",2),16)



'Bugs, errors and improvements
'-----------------------------

'If you find a bug, get an error, need help using the functions or can
'suggest or have made any improvements, please contact me on one of the
'e-mail addresses listed below. I have tested both functions and they
'seem to work alright.

'If you get an error, first ensure that every parameter passed and the
'result of of the correct data type. e.g. Strings where strings should
'be passed, numbers where numbers should be passed, etc.

'The functions don't like numbers being passed using exponents, for example
'3.215E+16

'The level of accuracy that Visual BASIC uses to store numbers sometimes
'gives slight errors. You should be alright up to at least
'101,559,956,668,415 in base 10 ("ZZZZZZZZZ" in base 36)!



'Version Information
'-------------------

'These functions were written using Visual BASIC 3 for Windows 3.11.
'However, there are no special version-specific commands, so any
'version of Visual BASIC should be alright.



'Legal Information
'-----------------

'I give absolutely no guarantee whatsoever that these functions work and do
'anything I say they do. You use them completely at your own risk.

'This code is placed in the Public Domain. (PD). You may modify it, use
'it in your own programs, or use it however you see fit. A mention in
'some credits would be nice though! :)



'Contacting the Author
'---------------------

'These functions were written by:

'Ian Howlett.

'CompuServe: 101720,3025
'Internet:   igh@compuserve.com
'FidoNet:    2:2500/708.20     (Last resort!)
'Web:        http://ourworld.compuserve.com/homepages/igh

Function BaseToDecimal (Number As String, BaseNo As Integer)

'Converts a positive whole number in any base from 2 to 36 into a decimal
'(base 10) number.
'
'Does NOT deal with real numbers (having a decimal point)
'or negative numbers (smaller than 0).
'
'
'SYNTAX for use:
'
'DecimalToBase (Number To Convert, Base the number is currently stored in)
'
'Where: Number To Convert is a string. If you are giving a value rather
'            than a string-type variable, enclose the value in "".
'       Base the number is currently stored in is an integer from 2 to 36

'       The result of the function is returned as type variant.



On Error GoTo BaseToDecimal_Error

Static BaseChars(0 To 35) As String
Dim AmountLeft, c1, c2, Temp  As Integer
Dim Result As Double
Dim NumberStr As String

Erase BaseChars

'Define Base characters
BaseChars(0) = "0"
BaseChars(1) = "1"
BaseChars(2) = "2"
BaseChars(3) = "3"
BaseChars(4) = "4"
BaseChars(5) = "5"
BaseChars(6) = "6"
BaseChars(7) = "7"
BaseChars(8) = "8"
BaseChars(9) = "9"
BaseChars(10) = "A"
BaseChars(11) = "B"
BaseChars(12) = "C"
BaseChars(13) = "D"
BaseChars(14) = "E"
BaseChars(15) = "F"
BaseChars(16) = "G"
BaseChars(17) = "H"
BaseChars(18) = "I"
BaseChars(19) = "J"
BaseChars(20) = "K"
BaseChars(21) = "L"
BaseChars(22) = "M"
BaseChars(23) = "N"
BaseChars(24) = "O"
BaseChars(25) = "P"
BaseChars(26) = "Q"
BaseChars(27) = "R"
BaseChars(28) = "S"
BaseChars(29) = "T"
BaseChars(30) = "U"
BaseChars(31) = "V"
BaseChars(32) = "W"
BaseChars(33) = "X"
BaseChars(34) = "Y"
BaseChars(35) = "Z"


'Check base is within range
If BaseNo < 2 Or BaseNo > 36 Then Exit Function

'Ensure any letters in Number are upper case
Number = UCase$(Number)

'Check that there are no characters used in Number that are not supported
'by the base the number is represented in.

'Uses Temp as a flag to show that a character has been found
For c1 = 1 To Len(Number)
    Temp = False
    For c2 = 0 To (BaseNo - 1)
        If Mid$(Number, c1, 1) = BaseChars(c2) Then
            Temp = True
            Exit For
        End If
    Next c2
If Temp = False Then
    MsgBox "The number passed to BaseToDecimal is NOT stored in base " + Format$(BaseNo) + " as stated."
    Exit Function
End If
Next c1


'Work through Number from left to right

Result = 0
For c1 = 1 To Len(Number)
    'find what the character represents
    For c2 = 0 To 36
        If Mid$(Number, c1, 1) = BaseChars(c2) Then
            Temp = c2
            Exit For
        End If
    Next c2
    Result = Result + Temp * (BaseNo ^ (Len(Number) - c1))
Next c1

BaseToDecimal = Result

Exit Function


BaseToDecimal_Error:
MsgBox "There was an error converting " + Format$(Number) + " to base " + Format$(BaseNo) + ". The error was " + Error$(Err), , "Error in Base Conversion"
Exit Function
Resume

End Function

Function DecimalToBase (Number, BaseNo As Integer) As String

'Converts a positive decimal (base 10) whole number into any base
'from 2 to 36.
'
'Does NOT deal with real numbers (having a decimal point)
'or negative numbers (smaller than 0).
'
'
'SYNTAX for use:
'
'DecimalToBase (Number To Convert, Base to convert into)
'
'Where: Number To Convert is a whole number
'       Base to convert into is an integer from 2 to 36
'
'       The result of the function is returned as a string.



On Error GoTo DecimalToBase_Error

Static BaseChars(0 To 35) As String
Dim AmountLeft, Power, c1, Temp As Integer
Dim Result As String

Erase BaseChars

'Check base
If BaseNo < 2 Or BaseNo > 36 Then Exit Function

'Define Base characters
BaseChars(0) = "0"
BaseChars(1) = "1"
BaseChars(2) = "2"
BaseChars(3) = "3"
BaseChars(4) = "4"
BaseChars(5) = "5"
BaseChars(6) = "6"
BaseChars(7) = "7"
BaseChars(8) = "8"
BaseChars(9) = "9"
BaseChars(10) = "A"
BaseChars(11) = "B"
BaseChars(12) = "C"
BaseChars(13) = "D"
BaseChars(14) = "E"
BaseChars(15) = "F"
BaseChars(16) = "G"
BaseChars(17) = "H"
BaseChars(18) = "I"
BaseChars(19) = "J"
BaseChars(20) = "K"
BaseChars(21) = "L"
BaseChars(22) = "M"
BaseChars(23) = "N"
BaseChars(24) = "O"
BaseChars(25) = "P"
BaseChars(26) = "Q"
BaseChars(27) = "R"
BaseChars(28) = "S"
BaseChars(29) = "T"
BaseChars(30) = "U"
BaseChars(31) = "V"
BaseChars(32) = "W"
BaseChars(33) = "X"
BaseChars(34) = "Y"
BaseChars(35) = "Z"


'Determine column at which to start

Power = -1
Do
    Power = Power + 1
Loop Until (BaseNo ^ Power) > Number
Power = Power - 1


AmountLeft = Number
                     
For c1 = Power To 0 Step -1
    Temp = Int(AmountLeft / (BaseNo ^ c1))
    If Temp = BaseNo Then
        Result = Result + BaseChars(0)
    Else
        Result = Result + BaseChars(Temp)
    End If
    AmountLeft = AmountLeft - (Temp * (BaseNo ^ c1))
Next c1

If Result = "" Then Result = BaseChars(0)
DecimalToBase = Result

Exit Function


DecimalToBase_Error:
MsgBox "There was an error converting " + Format$(Number) + " to base " + Format$(BaseNo) + ". The error was " + Error$(Err), , "Error in Base Conversion"
Exit Function
Resume

End Function

